/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin;

import com.st0x0ef.stellaris.common.network.packets.SyncPlanetMenuState;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.CustomPlayerData;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements CustomPlayerData {
    @Unique
    private boolean stellaris$isPlanetMenuOpened = false;

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"eat(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/food/FoodProperties;)Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    private void cancelEat(Level level, ItemStack foodStack, FoodProperties foodProperties, CallbackInfoReturnable<ItemStack> cir) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && !PlanetUtil.hasOxygenAt(serverLevel = (ServerLevel)level, this.getOnPos()) && !foodStack.is(TagRegistry.SPACE_FOOD)) {
            cir.setReturnValue((Object)foodStack);
        }
    }

    @Override
    public void stellaris$setPlanetMenuOpen(boolean open, Player player, boolean sync) {
        this.stellaris$isPlanetMenuOpened = open;
        if (sync && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPlanetMenuState(open));
        }
    }

    @Override
    public boolean stellaris$isPlanetMenuOpen() {
        return this.stellaris$isPlanetMenuOpened;
    }
}

